/*****************************************************************************
 $Id: TRexApp.java,v 1.10 2002/04/28 21:37:26 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex;

import javax.swing.UIManager;
import java.awt.*;

import trex.GUI.*;

/**
 * TRex Application.
 * This is a demo program for steganography algorithms.
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.10 $
 */

public class TRexApp {
  boolean packFrame = false;

  /**Construct the application*/
  public TRexApp() {
    MainFrame frame = new MainFrame(picfilename,
                                    datafilename,
                                    algorithmname);
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame) {
      frame.pack();
    }
    else {
      frame.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);
  }

  /**Print Info on screen */
  static void printInfo() {
    System.out.println("TRex Steganography demo");
    System.out.println("(c) 2001, 2002 Bastian Friedrich - Licensed under the GPL");
    System.out.println();
    System.out.println("Start with parameter --help to get help.");

    // Check for Java 1.4
    String javaVersion = null;
    int major = 0;
    int minor = 0;

    try {
      javaVersion = System.getProperty("java.version");
      major = (new Integer(javaVersion.substring(0,1))).intValue();
      minor = (new Integer(javaVersion.substring(2,3))).intValue();
    }

    // Exit on JVM missmatch.
    catch (Exception e) {
      System.out.println("Could not detect java version. Aborting.");
      System.exit(-1);
    }

    if ((major < 2) && (minor < 4)) {
      System.out.println("This program needs java 1.4 or newer. Aborting.");
      System.exit(-1);
    }
  }

  static String picfilename = null;
  static String datafilename = null;
  static String algorithmname = null;

  public static void synopsis() {
    System.out.println("Valid parameters:");
    System.out.println("   --help|-h      - You're reading it.");
    System.out.println("   -f <filename>  - Use this as the uncrypted image");
    System.out.println("   -d <filename>  - Use this as data to encrypt");
    System.out.println("   -a <algorithm> - use this algorithm");
//    System.out.println("   -c <filename>  - Load crypted - not yet implemented");
//    System.out.println("   -s <filename>  - Save to crypted - not yet implemented");
    System.exit(0);
  }

  /**
   * Parse parameters.
   * @param args command line arguments.
   */
  public static void parseParams(String[] args) {
    if (args.length == 0) return;
    int i = 0;
    while (i < args.length) {

      if (args[i].toLowerCase().equals("-h") || args[i].toLowerCase().equals("--help")) {
        synopsis();
      } else if (args[i].toLowerCase().equals("-f")) {
        if (i+1 >= args.length) synopsis();
        ++i;
        picfilename = args[i];
      } else if (args[i].toLowerCase().equals("-d")) {
        if (i+1 >= args.length) synopsis();
        ++i;
        datafilename = args[i];
      } else if (args[i].toLowerCase().equals("-a")) {
        if (i+1 >= args.length) synopsis();
        ++i;
        algorithmname = args[i];
      } else synopsis();
      ++i;
    }
    TRexUtil.printDebug("Filename: " + picfilename + " - data: " + datafilename);
  }

  /**Main method*/
  public static void main(String[] args) {
    printInfo();
    parseParams(args);
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    new TRexApp();
  }
}