/*****************************************************************************
 $Id: ImagePreview.java,v 1.5 2002/04/07 23:58:52 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI.ImageChooser;

import javax.swing.*;
import java.beans.*;
import java.awt.*;
import java.io.File;

/**
 * The <code>ImagePreview</code> creates a thumbnail for files.
 * It uses <code>ImageIcon</code> to read and resize images.
 * <p>This class was mostly stolen from Sun's documentation:
 * <a href="http://java.sun.com/docs/books/tutorial/uiswing/components/filechooser.html">FileChooser
 * Demo</a> (whoops... does this hurt GPL?!)</p>
 * @see javax.swing.ImageIcon
 * @see java.awt.Image
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.5 $
 */
public class ImagePreview extends JComponent
                          implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;

    /**
     * Constructs a new ImagePreview.
     * @param fc parent filechooser
     */
    public ImagePreview(JFileChooser fc) {
        setPreferredSize(new Dimension(100, 50));
        fc.addPropertyChangeListener(this);
    }

    /**
     * Load file.
     */
    private void loadImage() {
        if (file == null) {
            return;
        }

        ImageIcon tmpIcon = new ImageIcon(file.getPath());
        if (tmpIcon.getIconWidth() > 90) {
            thumbnail = new ImageIcon(tmpIcon.getImage().
                                 getScaledInstance(90, -1,
                                                   Image.SCALE_DEFAULT));
        } else {
            thumbnail = tmpIcon;
        }
    }

    /**
     * Respond to file selections and the like.
     * @param e Event to respond to
     */
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals(JFileChooser.SELECTED_FILE_CHANGED_PROPERTY)) {
            file = (File) e.getNewValue();
            if (isShowing()) {
                loadImage();
                repaint();
            }
        }
    }

    /**
     * perform image painting
     * @param g Graphics to paint icon in
     */
    public void paintComponent(Graphics g) {
        if (thumbnail == null) {
            loadImage();
        }
        if (thumbnail != null) {
            int x = getWidth()/2 - thumbnail.getIconWidth()/2;
            int y = getHeight()/2 - thumbnail.getIconHeight()/2;

            if (y < 0) {
                y = 0;
            }

            if (x < 5) {
                x = 5;
            }
            thumbnail.paintIcon(this, g, x, y);
        }
    }
}
