/*
 * $Id: benchmark.h 825 2007-02-16 13:04:16Z bastian $
 *
 * Benchmarking module for OpenSER
 *
 * Copyright (C) 2007 Collax GmbH
 *                    (Bastian Friedrich <bastian.friedrich@collax.com>)
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef BENCHMARK_MOD_H
#define BENCHMARK_MOD_H

#include "benchmark_api.h"

#define BENCHMARK_TIMERS 32

/* Exported functions */

int usr_start_timer(struct sip_msg* _msg, char* timer, char *foobar);
int usr_log_timer(struct sip_msg* _msg, char* timer, char* mystr);

struct benchmark_timer_t {
	int enabled;
	struct timeval start;	/* Current timer run */
	long calls;		/* Number of runs of this timer */
	long sum;		/* Accumulated runtime of this timer */
	long last_sum;		/* Accumulated runtime since last logging */
	long last_max;		/* Minimum in current period (between granularity) */
	long last_min;		/* Maximum ... */
	long global_max;	/* Global minimum, since start */
	long global_min;	/* ...    maximum ... */
};

#endif /* BENCHMARK_MOD_H */
